<?
function setdefault(&$var, $default="") {

	if (! isset($var)) {
		$var = $default;
	}
}

function nvl(&$var, $default="") {

	return isset($var) ? $var : $default;
}

function ov(&$var) {

	return isset($var) ? htmlSpecialChars(stripslashes($var)) : "";
}

function pv(&$var) {

	echo isset($var) ? htmlSpecialChars(stripslashes($var)) : "";
}

function o($var) {

	return empty($var) ? "" : htmlSpecialChars(stripslashes($var));
}

function p($var) {

	echo empty($var) ? "" : htmlSpecialChars(stripslashes($var));
}

function db_query_loop($query, $prefix, $suffix, $found_str, $default="") {

	$output = "";
	$result = db_query($query);
	while (list($val, $label) = db_fetch_row($result)) {
		if (is_array($default))
			$selected = empty($default[$val]) ? "" : $found_str;
		else
			$selected = $val == $default ? $found_str : "";

		$output .= "$prefix value='$val' $selected>$label$suffix";
	}

	return $output;
}

function db_listbox($query, $default="", $suffix="\n") {

	return db_query_loop($query, "<option", $suffix, "selected", $default);
}

function strip_querystring($url) {

	if ($commapos = strpos($url, '?')) {
		return substr($url, 0, $commapos);
	} else {
		return $url;
	}
}

function get_referer() {

	$HTTP_REFERER = getenv("HTTP_REFERER");
	return strip_querystring(nvl($HTTP_REFERER));
}

function me() {

	if (getenv("REQUEST_URI")) {
		$me = getenv("REQUEST_URI");

	} elseif (getenv("PATH_INFO")) {
		$me = getenv("PATH_INFO");

	} elseif ($GLOBALS["PHP_SELF"]) {
		$me = $GLOBALS["PHP_SELF"];
	}

	return strip_querystring($me);
}

function qualified_me() {

	$HTTPS = getenv("HTTPS");
	$SERVER_PROTOCOL = getenv("SERVER_PROTOCOL");
	$HTTP_HOST = getenv("HTTP_HOST");

	$protocol = (isset($HTTPS) && $HTTPS == "on") ? "https://" : "http://";
	$url_prefix = "$protocol$HTTP_HOST";
	return $url_prefix . me();
}

function match_referer($good_referer = "") {

	if ($good_referer == "") { $good_referer = qualified_me(); }
	return $good_referer == get_referer();
}

function redirect($url, $message="", $delay=0) {
	echo "<meta http-equiv='Refresh' content='$delay; url=$url'>";
	if (!empty($message)) echo "<div style='font-family: Arial, Sans-serif; font-size: 12pt;' align=center>$message</div>";
	die;
}

function read_template($filename, &$var) {

	$temp = str_replace("\\", "\\\\", implode(file($filename), ""));
	$temp = str_replace('"', '\"', $temp);
	eval("\$template = \"$temp\";");
	return $template;
}

function checked(&$var, $set_value = 1, $unset_value = 0) {

	if (empty($var)) {
		$var = $unset_value;
	} else {
		$var = $set_value;
	}
}

function frmchecked(&$var, $true_value = "checked", $false_value = "") {

	if ($var) {
		echo $true_value;
	} else {
		echo $false_value;
	}
}

?>